//%attributes = {}
// Method: pr_ AmountStock2ToStock1
// 2005.09.09-15:49:03 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: Converts amount from stock unit 2 to stock unit 1
// 
// ------------------------------------------------------------
C_REAL:C285($0; $1; $2)
C_LONGINT:C283($3)  //round value to default decimals
C_REAL:C285($pr_rStock1Amount; $pr_rStock2Amount; $pr_rMultiplier)

$pr_rStock2Amount:=$1
$pr_rMultiplier:=$2

If ($pr_rMultiplier=kGet)  //-10022
	If (_rec Loaded(pr_kTbl)=kFalse)
		_err MESSAGE(_lang Current("Product record is not loaded, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
	Else 
		$pr_rMultiplier:=_fld ValueReal(pr_kConversion_Multiplier)
	End if 
End if 

If ($pr_rMultiplier#-1)
	// from unit 2 to unit 1 we need to multiply
	$pr_rStock1Amount:=$pr_rStock2Amount*$pr_rMultiplier
Else   //-1 = inverse number
	If ($pr_rStock2Amount#0)
		$pr_rStock1Amount:=1/$pr_rStock2Amount
	Else 
		$pr_rStock1Amount:=0
	End if 
End if 

If ($3=kTrue)  //round values to default product rounded value
	$pr_rStock1Amount:=Round:C94($pr_rStock1Amount; <>pr_iPyörMäär)
End if 
$0:=$pr_rStock1Amount
